#ifndef QRFEPROGRESSDIALOG_H
#define QRFEPROGRESSDIALOG_H

#include <QWidget>
#include <ui_QrfeProgressDialog.h>
#include <QrfeGuiLibGlobal>

class QTimer;

class QrfeProgressDialog : public QDialog
{
    Q_OBJECT

public:
    QrfeProgressDialog(QrfeGlobal::ProgressBarMode mode, QWidget *parent = 0);
    QrfeProgressDialog(QString text, QrfeGlobal::ProgressBarMode mode, QWidget *parent = 0);
    QrfeProgressDialog(QString text, uint steps, QWidget *parent = 0);
    ~QrfeProgressDialog();

    QString title();
    void 	setTitle(QString title);

    QString text();
    void 	setText(QString text);

    int 	maxmimum();
    void 	setMaximum(int maximum);

    bool 	selfIncrement();
    void 	setSelfIncrement(bool on);

    bool    stopable() const;
    void    setStopable(bool stopable);

    bool stopped() const;

public slots:
    virtual void setVisible ( bool visible );

	void resetPorgressBar();
    void increasePorgressBar();
    void progressChanged(int steps, int overall);

private slots:
	void doSelfIncrement();
    void stopButtonClicked();

private:
	void prepare();

    Ui::QrfeProgressDialogClass 	ui;
    QrfeGlobal::ProgressBarMode 	m_mode;
    bool                            m_stopable;
    QString                         m_text;
    uint                            m_maximum;

    bool                            m_stopped;

    bool 							m_selfIncrement;
    QTimer* 						m_timer;
};

#endif // QRFEPROGRESSDIALOG_H
